//
//  XMethodLogger.h
//  Printer
//
//  Created by Apple Mac mini intel on 2024/9/24.
//  Copyright © 2024 Admin. All rights reserved.
//

#define LOG_METHOD_CALL_WITH_ARGS(...) \
    do { \
        if ([[XMethodLogger sharedLogger] isLoggingEnabled]) { \
            [[XMethodLogger sharedLogger] logMethodCall:NSStringFromSelector(_cmd) \
                withArguments:[NSString stringWithFormat:__VA_ARGS__] \
                fromClass:NSStringFromClass([self class])]; \
        } \
    } while(0)

#define LOG_METHOD_CALL_WITH_DATA(data) \
    do { \
        if ([[XMethodLogger sharedLogger] isLoggingEnabled]) { \
            [[XMethodLogger sharedLogger] logMethodCall:NSStringFromSelector(_cmd) \
                withArguments:[NSString stringWithFormat:@"NSData (HEX): %@, Length: %lu", \
                [[XMethodLogger sharedLogger] hexStringFromData:data], (unsigned long)data.length] \
                fromClass:NSStringFromClass([self class])]; \
        } \
    } while(0)

#import <Foundation/Foundation.h>

@interface XMethodLogger : NSObject

+ (instancetype)sharedLogger;

@property (nonatomic, assign) BOOL isLoggingEnabled;

- (void)logMethodCall:(NSString *)methodName withArguments:(NSString *)arguments;

- (void)logMethodCall:(NSString *)methodName withArguments:(NSString *)arguments fromClass:(NSString *)className;

- (NSURL *)exportLogsToFile;

- (NSString *)hexStringFromData:(NSData *)data;

- (void)clearLogs;


@end


